//=============================================================================
// Weapon{hotonSniperRifle.
//=============================================================================
class WeaponPhotonSniperRifle extends PhotonWeapon;

var float	mpNoScopeMult;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;
      bHasMuzzleFlash = True;
      ReloadCount = 4;
      ReloadTime = ShotTime;
	}
}

//
// functions to change ammo types
//
function bool LoadAmmo(int ammoNum)
{
	local class<Ammo> newAmmoClass;
	local Ammo newAmmo;
	local Pawn P;

	if ((ammoNum < 0) || (ammoNum > 2))
		return False;

	P = Pawn(Owner);

	// sorry, only pawns can have weapons
	if (P == None)
		return False;

	newAmmoClass = AmmoNames[ammoNum];

	if (newAmmoClass != None)
	{
		if (newAmmoClass != AmmoName)
		{
			newAmmo = Ammo(P.FindInventoryType(newAmmoClass));
			if (newAmmo == None)
			{
				P.ClientMessage(Sprintf(msgOutOf, newAmmoClass.Default.ItemName));
				return False;
			}
			
			// if we don't have a projectile for this ammo type, then set instant hit
			if (ProjectileNames[ammoNum] == None)
			{
				bInstantHit = True;
				bAutomatic = Default.bAutomatic;
				ShotTime = Default.ShotTime;
				if ( Level.NetMode != NM_Standalone )
				{
					if (HasReloadMod())
						ReloadTime = mpReloadTime * (1.0+ModReloadTime);
					else
						ReloadTime = mpReloadTime;
				}
				else
				{
					if (HasReloadMod())
						ReloadTime = Default.ReloadTime * (1.0+ModReloadTime);
					else
						ReloadTime = Default.ReloadTime;
				}
				FireSound = Default.FireSound;
				ProjectileClass = None;
			}
			else
			{
			AmmoName = newAmmoClass;
			AmmoType = newAmmo;

				// otherwise, set us to fire projectiles
				bInstantHit = False;
				bAutomatic = Default.bAutomatic;
				ShotTime = Default.ShotTime;
				if (HasReloadMod())
					ReloadTime = 2.0 * (1.0+ModReloadTime);
				else
					ReloadTime = 2.0;
				FireSound = Default.FireSound;		// handled by the projectile
				ProjectileClass = ProjectileNames[ammoNum];
				ProjectileSpeed = ProjectileClass.Default.Speed;

				if ( AmmoWhitePhoton(newAmmo) != None )
                                	{
                                        ShotTime = 4.000000;
                                        ReloadCount = 1;
                                        FireSound = Sound'DeusExSounds.Weapons.GepGunFire';
                                        }
				if ( AmmoBlackPhoton(newAmmo) != None )
                                        {
                                        ShotTime = Default.ShotTime;
                                        ReloadCount = Default.ReloadCount;
                                        FireSound = Default.FireSound;
                                        }
                                }
			AmmoName = newAmmoClass;
			AmmoType = newAmmo;

			// AlexB had a new sound for 20mm but there's no mechanism for playing alternate sounds per ammo type
			// Same for WP rocket
			if ( Ammo20mm(newAmmo) != None )
				FireSound=Sound'AssaultGunFire20mm';
			else if ( AmmoRocketWP(newAmmo) != None )
				FireSound=Sound'GEPGunFireWP';
			else if ( AmmoRocket(newAmmo) != None )
				FireSound=Sound'GEPGunFire';

			if ( Level.NetMode != NM_Standalone )
				SetClientAmmoParams( bInstantHit, bAutomatic, ShotTime, FireSound, ProjectileClass, ProjectileSpeed );

			// Notify the object belt of the new ammo
			if (DeusExPlayer(P) != None)
				DeusExPlayer(P).UpdateBeltText(Self);

			ReloadAmmo();

			P.ClientMessage(Sprintf(msgNowHas, ItemName, newAmmoClass.Default.ItemName));
			return True;
		}
		else
		{
			P.ClientMessage(Sprintf(MsgAlreadyHas, ItemName, newAmmoClass.Default.ItemName));
		}
	}
	return False;
}

defaultproperties
{
     mpNoScopeMult=0.350000
     LowAmmoWaterMark=6
     GoverningSkill=Class'DeusEx.SkillWeaponRifle'
     NoiseLevel=2.000000
     ShotTime=1.500000
     reloadTime=2.000000
     HitDamage=25
     maxRange=48000
     AccurateRange=28800
     bCanHaveScope=True
     bHasScope=True
     bCanHaveLaser=True
     bHasLaser=True
     AmmoNames(0)=Class'Markistan.AmmoBlackPhoton'
     AmmoNames(1)=Class'Markistan.AmmoWhitePhoton'
     ProjectileNames(0)=Class'Markistan.BlackPhotonBlast'
     ProjectileNames(1)=Class'Markistan.WhitePhotonNuke'
     bHasMuzzleFlash=False
     recoilStrength=0.400000
     bUseWhileCrouched=False
     mpReloadTime=2.000000
     mpHitDamage=25
     mpAccurateRange=28800
     mpMaxRange=28800
     mpReloadCount=4
     bCanHaveModBaseAccuracy=True
     bCanHaveModReloadCount=True
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     AmmoName=Class'Markistan.AmmoBlackPhoton'
     ReloadCount=4
     PickupAmmoCount=12
     FireOffset=(X=-25.000000,Y=2.500000,Z=37.500000)
     ProjectileClass=Class'Markistan.BlackPhotonBlast'
     shakemag=50.000000
     FireSound=Sound'Markistan.Weapons.PhotonSniperRifleFire'
     AltFireSound=Sound'DeusExSounds.Weapons.RifleReloadEnd'
     CockingSound=Sound'DeusExSounds.Weapons.RifleReload'
     SelectSound=Sound'DeusExSounds.Weapons.RifleSelect'
     InventoryGroup=182
     ItemName="FP-31 Photon Sniper Rifle"
     PlayerViewOffset=(X=25.000000,Y=-2.500000,Z=-37.500000)
     PlayerViewMesh=LodMesh'DeusExItems.SniperRifle'
     PlayerViewScale=1.250000
     PickupViewMesh=LodMesh'DeusExItems.SniperRiflePickup'
     PickupViewScale=1.250000
     ThirdPersonMesh=LodMesh'DeusExItems.SniperRifle3rd'
     ThirdPersonScale=1.250000
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'DeusExUI.Icons.BeltIconRifle'
     largeIcon=Texture'DeusExUI.Icons.LargeIconRifle'
     largeIconWidth=159
     largeIconHeight=47
     invSlotsX=5
     Description="This sniper rifle uses top-grade, almost unstoppable pure black photon, while the bullet is small, it has very high density and can shred through anything, if fired right. And for the missions where you say screw this, there is the attached white photonic nuclear bomb launcher. Say hello to 'the black death' or the FP-31"
     beltDescription="FP-31"
     Mesh=LodMesh'DeusExItems.SniperRiflePickup'
     DrawScale=1.250000
     CollisionRadius=32.500000
     CollisionHeight=2.500000
     Mass=45.000000
}
